

def calculate_mae(actual, predicted):
    """
    Calculate Mean Absolute Error (MAE) between two lists of floats.

    :param actual: List of actual values.
    :param predicted: List of predicted values.
    :return: MAE as a float.
    """
    if len(actual) != len(predicted):
        raise ValueError("The length of actual and predicted lists must be the same.")

    mae = sum(abs(a - p) for a, p in zip(actual, predicted)) / len(actual)
    return mae


gt = [93.6169, 91.027, 89.7198, 88.3343, 88.5264, 91.6123, 89.3574, 90.0, 91.3095, 87.799]
pred = [98.345, 97.9821, 99.2213, 100.562, 101.889, 101.215, 100.542, 99.8721, 98.201, 97.5102]
# pred = [97.619, 96.7742, 97.9592, 97.9592, 97.9592, 97.9592, 97.9592, 97.9592, 97.9592, 97.9592]

print(calculate_mae(gt, pred))
